import os
import json
import torch
import csv
# from core.data_utils.dataset import CustomDGLDataset

def load_data(dataset, use_dgl=False, seed=0, dataset_folder="/data/shared/graph_datasets_backup/"):
    if dataset == 'cora':
        from raw_data_utils.load_cora import get_raw_text
    elif dataset == 'pubmed':
        from raw_data_utils.load_pubmed import get_raw_text
    elif dataset == 'ogbn-arxiv':
        from raw_data_utils.load_arxiv import get_raw_text
    elif dataset == 'ogbn-products':
        from raw_data_utils.load_products import get_raw_text
    else:
        exit(f'Error: Dataset {dataset} not supported')
    
    return get_raw_text(seed=seed, dataset_folder=dataset_folder)
